<?php

header("Content-Type: application/json");
include ("../serive/samparka.php");

// Error logging function
function logError($message) {
    file_put_contents(__DIR__ . '/log.txt', date('Y-m-d H:i:s') . " - " . $message . "\n", FILE_APPEND);
}

// Log all incoming GET and POST data
$logData = [
    'timestamp' => date('Y-m-d H:i:s'),
    'method' => $_SERVER['REQUEST_METHOD'],
    'get' => $_GET,
    'post' => $_POST,
    'raw_input' => file_get_contents("php://input"),
    'remote_addr' => $_SERVER['REMOTE_ADDR']
];
file_put_contents(__DIR__ . '/request_log.txt', json_encode($logData) . PHP_EOL, FILE_APPEND);

$input = file_get_contents("php://input");
$data = json_decode($input, true);

// If JSON decode fails or is empty, use $_POST
if (!is_array($data) || empty($data)) {
    $data = $_POST;
}

// Extract and validate required parameters
$orderNumber = $data['orderCode'] ?? null;
$amount = $data['amount'] ?? null;
$status = $data['status'] ?? null;
$userCode = $data['userCode'] ?? null;
$sign = $data['sign'] ?? null;

if (!$orderNumber || !$amount || !$status || !$userCode || !$sign) {
    logError("Error: Missing required parameters");
    echo json_encode(["status" => false, "message" => "Missing required parameters"]);
    exit;
}

// Signature validation (keep as in your original)
$merchantKey = "vqusxhuW580iP4pEJXR2wrlhS8mdV2tI"; // Replace with actual key
$signString = $status ? "$orderNumber&$amount&$userCode&$status&$merchantKey" : "$orderNumber&$amount&$userCode&$merchantKey";
$expectedSign = strtoupper(md5($signString));
if ($sign !== $expectedSign) {
    logError("Invalid signature");
    echo json_encode(["status" => false, "message" => "Invalid signature"]);
    exit;
}

// Reward tiers function
function getRewardAmount($rechargeAmount) {
    $rewardTiers = [
        ['amount' => 100000, 'reward' => 8100],
        ['amount' => 50000, 'reward' => 4100],
        ['amount' => 10000, 'reward' => 1100],
        ['amount' => 5000, 'reward' => 600],
        ['amount' => 3000, 'reward' => 400],
        ['amount' => 1000, 'reward' => 200],
        ['amount' => 500, 'reward' => 150],
        ['amount' => 300, 'reward' => 50]
    ];
    foreach ($rewardTiers as $tier) {
        if ($rechargeAmount >= $tier['amount']) {
            return $tier['reward'];
        }
    }
    return 0;
}

// Use thevani table to find order and process
if ($status === '3') { // Payment success
    $checkamt = mysqli_query($conn, "SELECT t.motta, t.balakedara, t.sthiti, 
        (SELECT COUNT(*) FROM thevani WHERE balakedara = t.balakedara AND sthiti = '1') as recharge_count,
        (SELECT code FROM shonu_subjects WHERE id = t.balakedara) as referrer_code
        FROM thevani t 
        WHERE t.dharavahi = '".$orderNumber."' AND t.sthiti = '0'");

    if (!$checkamt) {
        logError("Database query error: " . mysqli_error($conn));
        echo json_encode(["status" => false, "message" => "Database query error"]);
        exit;
    }

    $checkamtrow = mysqli_num_rows($checkamt);

    if ($checkamtrow >= 1) {
        $checkamtar = mysqli_fetch_array($checkamt);
        $motta = $checkamtar['motta'];
        $shonuid = $checkamtar['balakedara'];
        $recharge_count = $checkamtar['recharge_count'];
        $referrer_code = $checkamtar['referrer_code'];

        // Update user's balance
        $nabikarana = "UPDATE shonu_kaichila 
                       SET motta = ROUND(motta + '".$motta."', 2) 
                       WHERE balakedara = '".$shonuid."'";
        
        if (!$conn->query($nabikarana)) {
            logError("Database update error: " . mysqli_error($conn));
            echo json_encode(["status" => false, "message" => "Failed to update wallet"]);
            exit;
        }

        // If this is user's first recharge, process referral bonus
        if ($recharge_count == 0 && $referrer_code) {
            $reward_amount = getRewardAmount($motta);
            if ($reward_amount > 0) {
                // Get referrer's ID
                $referrer_query = "SELECT id FROM shonu_subjects WHERE owncode = '".$referrer_code."'";
                $referrer_result = $conn->query($referrer_query);
                if ($referrer_row = mysqli_fetch_array($referrer_result)) {
                    $referrer_id = $referrer_row['id'];
                    // Update referrer's balance
                    $referrer_update = "UPDATE shonu_kaichila 
                                      SET motta = ROUND(motta + '".$reward_amount."', 2) 
                                      WHERE balakedara = '".$referrer_id."'";
                    if (!$conn->query($referrer_update)) {
                        logError("Referral bonus update error: " . mysqli_error($conn));
                    } else {
                        // Log the referral bonus transaction
                        $bonus_log = mysqli_query($conn, "INSERT INTO vyavahara 
                            (balakedara, ketebida, prakara, ayoga, koduvavanu, tiarikala) 
                            VALUES 
                            ('".$referrer_id."', '".$motta."', 'REFERRAL_BONUS', '".$reward_amount."', 
                             '".$shonuid."', '".date('Y-m-d H:i:s')."')");
                        if (!$bonus_log) {
                            logError("Referral bonus log error: " . mysqli_error($conn));
                        }
                    }
                }
            }
        }

        // Update order status
        $sql2 = mysqli_query($conn, "UPDATE thevani SET sthiti = '1' WHERE dharavahi = '".$orderNumber."'");
        if (!$sql2) {
            logError("Order status update error: " . mysqli_error($conn));
            echo json_encode(["status" => false, "message" => "Failed to update order status"]);
            exit;
        }
        echo json_encode(["status" => true, "message" => "Payment successful, wallet updated"]);
    } else {
        echo json_encode(["status" => false, "message" => "Order not found or already processed"]);
    }
} elseif ($status === "1") { // Payment in progress
    echo json_encode(["status" => false, "message" => "Payment still in progress"]);
} else { // Payment failed
    $updatePayment = mysqli_query($conn, "UPDATE thevani SET sthiti = '2' WHERE dharavahi = '".$orderNumber."'");
    echo json_encode(["status" => false, "message" => "Payment failed"]);
}
exit;
?>